<?php
/*--------------------------------------------------------------------------------------------------
    ServiceProvider.php 2020-02-18
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2020 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */

namespace Gambio\Shop\Properties\SellingUnitQuantitiy\Database;

use Doctrine\DBAL\Connection;
use Gambio\Core\Event\EventListenerProvider;
use Gambio\Shop\Properties\Database\Services\Interfaces\PropertiesReaderServiceInterface;
use Gambio\Shop\Properties\SellingUnitQuantitiy\Database\Listeners\OnGetSelectedQuantityEventListener;
use Gambio\Shop\Properties\SellingUnitQuantitiy\Database\Listeners\OnGetSellingUnitAvailableQuantityListener;
use Gambio\Shop\Properties\SellingUnitQuantitiy\Database\Readers\PropertyQuantityReader;
use Gambio\Shop\Properties\SellingUnitQuantitiy\Database\Readers\PropertyQuantityReaderInterface;
use Gambio\Shop\Properties\SellingUnitQuantitiy\Database\Services\PropertyQuantityReadService;
use Gambio\Shop\Properties\SellingUnitQuantitiy\Database\Services\PropertyQuantityReadServiceInterface;
use Gambio\Shop\SellingUnit\Database\Unit\Events\OnGetSelectedQuantityEvent;
use Gambio\Shop\SellingUnit\Database\Unit\Events\OnGetSellingUnitAvailableQuantityEvent;
use League\Container\Container;
use League\Container\ServiceProvider\AbstractServiceProvider;
use League\Container\ServiceProvider\BootableServiceProviderInterface;

/**
 * @property  Container container
 */
class ServiceProvider extends AbstractServiceProvider implements BootableServiceProviderInterface
{
    /**
     * @var array
     */
    protected $provides = [
        OnGetSellingUnitAvailableQuantityListener::class,
        OnGetSelectedQuantityEventListener::class
    ];


    /**
     * @inheritDoc
     */
    public function boot()
    {
        /** @var EventListenerProvider $listenerProvider */
        $listenerProvider = $this->container->get(EventListenerProvider::class);
        $listenerProvider->attachListener(OnGetSellingUnitAvailableQuantityEvent::class,
            OnGetSellingUnitAvailableQuantityListener::class);
        $listenerProvider->attachListener(OnGetSelectedQuantityEvent::class,
            OnGetSelectedQuantityEventListener::class);
    }


    /**
     * @inheritDoc
     */
    public function register()
    {
        $this->container->share(OnGetSellingUnitAvailableQuantityListener::class)
                        ->addArgument(PropertyQuantityReadServiceInterface::class);

        $this->container->share(OnGetSelectedQuantityEventListener::class)
                        ->addArgument(PropertiesReaderServiceInterface::class)
                        ->addArgument(PropertyQuantityReadServiceInterface::class);

        $this->container->share(PropertyQuantityReadServiceInterface::class, PropertyQuantityReadService::class)
                        ->addArgument(PropertiesReaderServiceInterface::class)
                        ->addArgument(defined('STOCK_CHECK') ? STOCK_CHECK === 'true' : false)
                        ->addArgument(defined('ATTRIBUTE_STOCK_CHECK') ? ATTRIBUTE_STOCK_CHECK === 'true' : false);

        $this->container->share(PropertyQuantityReaderInterface::class, PropertyQuantityReader::class)
                        ->addArgument(Connection::class);
    }
}